/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class JumpMove<A extends IAttacker<? extends A, ?>>
extends AbstractMove<JumpMove<A>, A> {
    private final float strength;

    public JumpMove(int cooldown, int windup, int duration, float moveDistance, float strength) {
        super(cooldown, windup, duration, moveDistance);
        this.strength = strength;
        this.mobilityType = MobilityType.DASH;
    }

    @Override
    @NonNull
    public MoveType<JumpMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    public boolean conditionsMet(A attacker) {
        return super.conditionsMet(attacker) && attacker.getUser().m_20096_();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        if (user.m_20096_()) {
            Vec3 upVel = Vec3.m_82528_((Vec3i)GravityChangerAPI.getGravityDirection((Entity)user).m_122436_()).m_82490_(-0.5);
            Vec3 jumpVel = Vec3.m_82498_((float)user.m_146909_(), (float)user.m_146908_()).m_82490_((double)this.strength).m_82549_(upVel);
            JUtils.setVelocity((Entity)user, jumpVel.f_82479_, jumpVel.f_82480_, jumpVel.f_82481_);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected JumpMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public JumpMove<A> copy() {
        return this.copyExtras(new JumpMove<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.strength));
    }

    public float getStrength() {
        return this.strength;
    }

    public static class Type
    extends AbstractMove.Type<JumpMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<JumpMove<?>>, JumpMove<?>> buildCodec(RecordCodecBuilder.Instance<JumpMove<?>> instance) {
            return this.baseDefault(instance).and((App)Codec.FLOAT.fieldOf("strength").forGetter(JumpMove::getStrength)).apply(instance, this.applyExtras(JumpMove::new));
        }
    }
}

