/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class KnockdownAttack<A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<KnockdownAttack<A>, A> {
    private final int knockdownDuration;

    public KnockdownAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int knockdownDuration) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.knockdownDuration = knockdownDuration;
    }

    @Override
    protected void processTarget(A attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), this.knockdownDuration, 0, true, false));
    }

    @Override
    @NonNull
    public MoveType<KnockdownAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    protected KnockdownAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public KnockdownAttack<A> copy() {
        return this.copyExtras(new KnockdownAttack<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getKnockdownDuration()));
    }

    public int getKnockdownDuration() {
        return this.knockdownDuration;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<KnockdownAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KnockdownAttack<?>>, KnockdownAttack<?>> buildCodec(RecordCodecBuilder.Instance<KnockdownAttack<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)Codec.INT.fieldOf("knockdown_duration").forGetter(KnockdownAttack::getKnockdownDuration)).apply(instance, this.applyAttackExtras(KnockdownAttack::new));
        }
    }
}

