/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class KnockdownBarrageAttack<A extends IAttacker<? extends A, ?>>
extends AbstractBarrageAttack<KnockdownBarrageAttack<A>, A> {
    private final int knockdownDuration;

    public KnockdownBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval, int knockdownDuration) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
        this.knockdownDuration = knockdownDuration;
    }

    @Override
    protected void processTarget(A attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), this.knockdownDuration, 0, true, false));
    }

    @Override
    @NonNull
    public MoveType<KnockdownBarrageAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    protected KnockdownBarrageAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public KnockdownBarrageAttack<A> copy() {
        return this.copyExtras(new KnockdownBarrageAttack<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval(), this.getKnockdownDuration()));
    }

    public int getKnockdownDuration() {
        return this.knockdownDuration;
    }

    public static class Type
    extends AbstractBarrageAttack.Type<KnockdownBarrageAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KnockdownBarrageAttack<?>>, KnockdownBarrageAttack<?>> buildCodec(RecordCodecBuilder.Instance<KnockdownBarrageAttack<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.interval(), (App)Codec.INT.fieldOf("knockdown_duration").forGetter(KnockdownBarrageAttack::getKnockdownDuration)).apply(instance, this.applyAttackExtras(KnockdownBarrageAttack::new));
        }
    }
}

