/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class KnockdownMultiHitAttack<A extends IAttacker<? extends A, ?>>
extends AbstractMultiHitAttack<KnockdownMultiHitAttack<A>, A> {
    private final int knockdownDuration;

    public KnockdownMultiHitAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments, int knockdownDuration) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
        this.knockdownDuration = knockdownDuration;
    }

    @Override
    protected void processTarget(A attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), this.knockdownDuration, 0, true, false));
    }

    @Override
    @NonNull
    public MoveType<KnockdownMultiHitAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    protected KnockdownMultiHitAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public KnockdownMultiHitAttack<A> copy() {
        return this.copyExtras(new KnockdownMultiHitAttack<A>(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments(), this.knockdownDuration));
    }

    public int getKnockdownDuration() {
        return this.knockdownDuration;
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<KnockdownMultiHitAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KnockdownMultiHitAttack<?>>, KnockdownMultiHitAttack<?>> buildCodec(RecordCodecBuilder.Instance<KnockdownMultiHitAttack<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMoments(), (App)Codec.INT.fieldOf("knockdown_duration").forGetter(KnockdownMultiHitAttack::getKnockdownDuration)).apply(instance, this.applyAttackExtras(KnockdownMultiHitAttack::new));
        }
    }
}

