/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public final class MainBarrageAttack<A extends IAttacker<? extends A, ?>>
extends AbstractBarrageAttack<MainBarrageAttack<A>, A> {
    private static final int MINING_BARRAGE_TIME = 200;
    private final float mineableHardness;
    private final int baseStun;
    private final int baseDuration;
    private boolean breakBlocks = false;

    public MainBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval, float mineableHardness) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
        this.mineableHardness = mineableHardness;
        this.baseDuration = duration;
        this.baseStun = stun;
        this.withShockwaves();
        this.withHoldable();
    }

    @Override
    @NonNull
    public MoveType<MainBarrageAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    public void onInitiate(A attacker) {
        Player player;
        boolean bl = this.breakBlocks = attacker.getUserOrThrow().m_6144_() && JServerConfig.MINING_BARRAGE.getValue();
        if (this.breakBlocks && !this.mayGrief(attacker.getUser()) && !(attacker.getUser() instanceof Player) || attacker instanceof Player && !(player = (Player)attacker).m_36326_()) {
            this.breakBlocks = false;
        }
        this.withDuration(this.breakBlocks ? 200 : this.baseDuration);
        super.onInitiate(attacker);
        this.withStun(this.breakBlocks ? 1 : this.baseStun);
    }

    @Override
    public boolean canFinish(A attacker) {
        if (this.breakBlocks) {
            return false;
        }
        return super.canFinish(attacker);
    }

    @Override
    public void onUserMoveInput(A attacker, MoveInputType type, boolean pressed, boolean moveInitiated) {
        super.onUserMoveInput(attacker, type, pressed, moveInitiated);
        if (this.breakBlocks && type.getMoveClass() == this.getMoveClass() && !pressed) {
            attacker.cancelMove();
        }
    }

    @Override
    @NonNull
    protected MainBarrageAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (this.breakBlocks) {
            ServerLevel serverWorld = (ServerLevel)user.m_9236_();
            Vec3 lookDirection = user.m_20154_();
            Vec3 localUp = GravityChangerAPI.getEyeOffset((Entity)user);
            LivingEntity miner = attacker.isRemote() ? attacker.getBaseEntity() : user;
            Vec3 baseLookPos = miner.m_20182_().m_82549_(lookDirection);
            this.tryBreak(serverWorld, BlockPos.m_274446_((Position)baseLookPos), user);
            this.tryBreak(serverWorld, BlockPos.m_274446_((Position)baseLookPos.m_82549_(localUp)), user);
            this.tryBreak(serverWorld, BlockPos.m_274446_((Position)baseLookPos.m_82549_(lookDirection)), user);
            this.tryBreak(serverWorld, BlockPos.m_274446_((Position)baseLookPos.m_82549_(lookDirection).m_82549_(localUp)), user);
        }
        return targets;
    }

    private void tryBreak(ServerLevel world, BlockPos pos, LivingEntity user) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block.m_155943_() < 0.0f) {
            return;
        }
        if (block.m_155943_() <= this.mineableHardness && (user instanceof Player || world.m_46469_().m_46207_(GameRules.f_46132_))) {
            world.m_46953_(pos, true, (Entity)user);
        }
    }

    @Override
    @NonNull
    public MainBarrageAttack<A> copy() {
        return this.copyExtras(new MainBarrageAttack<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval(), this.mineableHardness));
    }

    public float getMineableHardness() {
        return this.mineableHardness;
    }

    public static class Type
    extends AbstractBarrageAttack.Type<MainBarrageAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<MainBarrageAttack<?>>, MainBarrageAttack<?>> buildCodec(RecordCodecBuilder.Instance<MainBarrageAttack<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.interval(), (App)Codec.FLOAT.fieldOf("mineable_hardness").forGetter(MainBarrageAttack::getMineableHardness)).apply(instance, this.applyAttackExtras(MainBarrageAttack::new));
        }
    }
}

