/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.jetbrains.annotations.NotNull;

public final class MovementSlowingSimpleAttack<A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<MovementSlowingSimpleAttack<A>, A> {
    public MovementSlowingSimpleAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    public static <A extends IAttacker<? extends A, ?>> MovementSlowingSimpleAttack<A> lightAttack(int windup, int duration, float moveDistance, float damage, int stun, float knockback, float offset) {
        return (MovementSlowingSimpleAttack)new MovementSlowingSimpleAttack<A>(duration, windup, duration, moveDistance, damage, stun, 1.5f, knockback, offset).noLoopPrevention();
    }

    @Override
    public void activeTick(A attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (attacker.hasUser() && !attacker.isRemote()) {
            attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 2, true, false));
        }
    }

    @Override
    @NotNull
    public MoveType<MovementSlowingSimpleAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    protected MovementSlowingSimpleAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public MovementSlowingSimpleAttack<A> copy() {
        return this.copyExtras(new MovementSlowingSimpleAttack<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<MovementSlowingSimpleAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<MovementSlowingSimpleAttack<?>>, MovementSlowingSimpleAttack<?>> buildCodec(RecordCodecBuilder.Instance<MovementSlowingSimpleAttack<?>> instance) {
            return this.attackDefault(instance, MovementSlowingSimpleAttack::new);
        }
    }
}

