/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.GoldExperienceEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public final class RekkaAttack<A extends IAttacker<A, S> & GeoEntity, S extends Enum<S>>
extends AbstractSimpleAttack<RekkaAttack<A, S>, A> {
    private final int rekkaLevel;
    private final RekkaAttack<A, S> next;
    private final int switchStart;
    private final StandAnimationState<A> nextState;

    public RekkaAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int rekkaLevel, int switchStart, RekkaAttack<A, S> next, StandAnimationState<A> nextState) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        if (rekkaLevel > 1) {
            this.hitSpark = JParticleType.HIT_SPARK_2;
        }
        this.rekkaLevel = rekkaLevel;
        this.switchStart = switchStart;
        this.next = next;
        this.nextState = nextState;
    }

    @Override
    @NonNull
    public MoveType<RekkaAttack<A, S>> getMoveType() {
        return null;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (this.rekkaLevel == 3) {
            for (LivingEntity target : targets) {
                if (JUtils.isBlocking(target)) continue;
                target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 50, 0, true, false));
            }
        }
        return targets;
    }

    public boolean mayAdvance(GoldExperienceEntity stand) {
        return stand.getMoveStun() < this.switchStart;
    }

    @Override
    @NonNull
    protected RekkaAttack<A, S> getThis() {
        return this;
    }

    @Override
    @NonNull
    public RekkaAttack<A, S> copy() {
        return this.copyExtras(new RekkaAttack<A, S>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getRekkaLevel(), this.getSwitchStart(), this.getNext(), this.getNextState()));
    }

    public int getRekkaLevel() {
        return this.rekkaLevel;
    }

    public RekkaAttack<A, S> getNext() {
        return this.next;
    }

    public int getSwitchStart() {
        return this.switchStart;
    }

    public StandAnimationState<A> getNextState() {
        return this.nextState;
    }
}

