/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.world.entity.LivingEntity;

public final class StandbyActivationMove<A extends IAttacker<? extends A, ?>>
extends AbstractMove<StandbyActivationMove<A>, A> {
    public StandbyActivationMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<StandbyActivationMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        if (attacker instanceof StandEntity) {
            StandEntity stand = (StandEntity)attacker;
            stand.setStandby(true);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected StandbyActivationMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public StandbyActivationMove<A> copy() {
        return this.copyExtras(new StandbyActivationMove<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<StandbyActivationMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<StandbyActivationMove<?>>, StandbyActivationMove<?>> buildCodec(RecordCodecBuilder.Instance<StandbyActivationMove<?>> instance) {
            return instance.group(this.cooldown(), this.windup(), this.duration(), this.moveDistance()).apply(instance, StandbyActivationMove::new);
        }
    }
}

