/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.tickable.Timestops;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JCodecUtils;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class TimeSkipMove<A extends IAttacker<? extends A, ?>>
extends AbstractMove<TimeSkipMove<A>, A> {
    private final List<Supplier<SoundEvent>> sounds = new ArrayList<Supplier<SoundEvent>>();
    private final double distance;
    private boolean particles = false;

    public TimeSkipMove(int cooldown, double distance) {
        super(cooldown, 0, 0, 0.0f);
        this.distance = distance;
        this.mobilityType = MobilityType.TELEPORT;
    }

    @Override
    public TimeSkipMove<A> withSound(SoundEvent sound) {
        this.sounds.add(() -> sound);
        return this;
    }

    @Override
    public TimeSkipMove<A> withSound(RegistrySupplier<SoundEvent> sound) {
        this.sounds.add((Supplier<SoundEvent>)sound);
        return this;
    }

    public TimeSkipMove<A> withSounds(Collection<Supplier<SoundEvent>> sounds) {
        this.sounds.addAll(sounds);
        return this;
    }

    public TimeSkipMove<A> withParticles() {
        return this.withParticles(true);
    }

    public TimeSkipMove<A> withParticles(boolean particles) {
        this.particles = particles;
        return this;
    }

    @Override
    @NonNull
    public MoveType<TimeSkipMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    public boolean conditionsMet(A attacker) {
        if (Timestops.getTimestop((Entity)attacker.getUser()) != null) {
            return false;
        }
        return super.conditionsMet(attacker);
    }

    @Override
    public void onInitiate(A attacker) {
        super.onInitiate(attacker);
        if (this.particles) {
            this.spawnParticles(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        TimeSkipMove.doTimeSkip(attacker, user, this.distance, this.getSounds().stream().map(Supplier::get).toList());
        return Set.of();
    }

    private void spawnParticles(A attacker) {
        LivingEntity user = attacker.getUserOrThrow();
        Vec3 pos = user.m_20182_();
        AABB bBox = user.m_20191_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(2);
        buf.writeDouble(pos.f_82479_);
        buf.writeDouble(pos.f_82480_);
        buf.writeDouble(pos.f_82481_);
        buf.writeDouble(bBox.m_82362_());
        buf.writeDouble(bBox.m_82376_());
        buf.writeDouble(bBox.m_82385_());
        ServerChannelFeedbackPacket.send(JUtils.around((ServerLevel)attacker.getBaseEntity().m_9236_(), pos, 128.0), buf);
    }

    public static void doTimeSkip(IAttacker<?, ?> attacker, LivingEntity user, double distance, List<SoundEvent> sounds) {
        boolean hasVehicle = user.m_20159_();
        if (hasVehicle) {
            distance /= 3.0;
        }
        Vec3 rotVec = user.m_20154_();
        Vec3 eyePos = user.m_146892_();
        BlockHitResult hitResult = attacker.getEntityWorld().m_45547_(new ClipContext(eyePos, eyePos.m_82549_(rotVec.m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user));
        Vec3 tpPos = hitResult.m_82450_();
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
        if (cooldowns.getCooldown(CooldownType.STAND_ULTIMATE) < 60) {
            cooldowns.setCooldown(CooldownType.STAND_ULTIMATE, 60);
        }
        if (hasVehicle) {
            Entity vehicle = user.m_20202_();
            user.m_21028_(vehicle);
            vehicle.m_6034_(tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_);
        }
        user.m_20324_(tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_);
        for (SoundEvent sound : sounds) {
            attacker.getEntityWorld().m_6263_(null, tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    @NonNull
    protected TimeSkipMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public TimeSkipMove<A> copy() {
        return this.copyExtras(new TimeSkipMove<A>(this.getCooldown(), this.distance).withParticles(this.particles).withSounds(this.sounds));
    }

    public List<Supplier<SoundEvent>> getSounds() {
        return this.sounds;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isParticles() {
        return this.particles;
    }

    public static class Type
    extends AbstractMove.Type<TimeSkipMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TimeSkipMove<?>>, TimeSkipMove<?>> buildCodec(RecordCodecBuilder.Instance<TimeSkipMove<?>> instance) {
            return instance.group(this.extras(), this.cooldown(), (App)Codec.DOUBLE.fieldOf("distance").forGetter(TimeSkipMove::getDistance), (App)Codec.BOOL.optionalFieldOf("particles", (Object)false).forGetter(TimeSkipMove::isParticles), (App)JCodecUtils.SOUND_EVENT_SUPPLIER_CODEC.listOf().optionalFieldOf("sounds", List.of()).forGetter(TimeSkipMove::getSounds)).apply(instance, this.applyExtras((cooldown, distance, particles, sounds) -> new TimeSkipMove((int)cooldown, (double)distance).withParticles((boolean)particles).withSounds((Collection<Supplier<SoundEvent>>)sounds)));
        }
    }
}

