/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractHoldableMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class TossChargeMove<A extends IAttacker<A, ?>>
extends AbstractHoldableMove<TossChargeMove<A>, A> {
    public TossChargeMove(int cooldown, int windup, int duration, float moveDistance, int minimumCharge) {
        super(cooldown, windup, duration, moveDistance, minimumCharge);
    }

    @Override
    @NonNull
    public MoveType<TossChargeMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    public void onInitiate(A attacker) {
        StandEntity stand;
        super.onInitiate(attacker);
        if (attacker instanceof StandEntity && !(stand = (StandEntity)attacker).m_9236_().m_5776_()) {
            ItemStack oldProjectile;
            LivingEntity user = stand.getUser();
            if (user == null) {
                return;
            }
            ItemStack projectileSource = user.m_21120_(InteractionHand.MAIN_HAND);
            if (projectileSource.m_41619_()) {
                projectileSource = user.m_21120_(InteractionHand.OFF_HAND);
            }
            if (!projectileSource.m_41619_() && (oldProjectile = stand.m_21120_(InteractionHand.MAIN_HAND)).m_41619_()) {
                stand.m_21008_(InteractionHand.MAIN_HAND, projectileSource.m_255036_(1));
                projectileSource.m_41774_(1);
            }
        }
    }

    @Override
    @NonNull
    protected TossChargeMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public TossChargeMove<A> copy() {
        return this.copyExtras(new TossChargeMove<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getMinimumCharge()));
    }

    public static class Type
    extends AbstractHoldableMove.Type<TossChargeMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TossChargeMove<?>>, TossChargeMove<?>> buildCodec(RecordCodecBuilder.Instance<TossChargeMove<?>> instance) {
            return instance.group(this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.minimumCharge()).apply(instance, TossChargeMove::new);
        }
    }
}

