/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class TossMove<A extends IAttacker<? extends A, ?>>
extends AbstractMove<TossMove<A>, A> {
    public TossMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<TossMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        StandEntity stand;
        if (attacker instanceof StandEntity && !(stand = (StandEntity)attacker).m_9236_().m_5776_()) {
            ItemStack projectile = stand.m_21120_(InteractionHand.MAIN_HAND);
            JUtils.tossItem((LivingEntity)stand, stand.m_9236_(), projectile, (float)this.getChargeTime() / 40.0f, true);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected TossMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public TossMove<A> copy() {
        return this.copyExtras(new TossMove<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<TossMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TossMove<?>>, TossMove<?>> buildCodec(RecordCodecBuilder.Instance<TossMove<?>> instance) {
            return instance.group(this.cooldown(), this.windup(), this.duration(), this.moveDistance()).apply(instance, TossMove::new);
        }
    }
}

