/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.minecraft.world.entity.LivingEntity;

public final class ArmorOffAttack
extends AbstractSimpleAttack<ArmorOffAttack, SilverChariotEntity> {
    public ArmorOffAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<ArmorOffAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(SilverChariotEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.setMode(SilverChariotEntity.Mode.ARMORLESS);
        attacker.setArmorTime(500);
        return targets;
    }

    @Override
    public void tick(SilverChariotEntity attacker) {
        this.tickArmor(attacker);
    }

    private void tickArmor(SilverChariotEntity stand) {
        if (stand.getMode() != SilverChariotEntity.Mode.ARMORLESS) {
            return;
        }
        if (stand.decrementArmorTime() <= 0) {
            stand.setMode(SilverChariotEntity.Mode.REGULAR);
        }
    }

    @Override
    @NonNull
    protected ArmorOffAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ArmorOffAttack copy() {
        return this.copyExtras(new ArmorOffAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<ArmorOffAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ArmorOffAttack>, ArmorOffAttack> buildCodec(RecordCodecBuilder.Instance<ArmorOffAttack> instance) {
            return this.attackDefault(instance, ArmorOffAttack::new);
        }
    }
}

