/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class CircleSlashAttack
extends AbstractSimpleAttack<CircleSlashAttack, SilverChariotEntity> {
    private final float originalDamage;

    public CircleSlashAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.originalDamage = damage;
    }

    @Override
    @NonNull
    public MoveType<CircleSlashAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SilverChariotEntity attacker) {
        super.onInitiate(attacker);
        this.withDamage(this.originalDamage);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(SilverChariotEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        this.withDamage(this.originalDamage + (float)(this.getChargeTime() / 10) * 0.75f);
        double launchMultiplier = this.getDamage() / 5.0f;
        for (LivingEntity living : targets) {
            Vec3 launchVec = living.m_20182_().m_82546_(user.m_20182_()).m_82541_().m_82490_(launchMultiplier);
            JUtils.addVelocity((Entity)living, launchVec.f_82479_, launchVec.f_82480_ + 0.2, launchVec.f_82481_);
        }
        return targets;
    }

    @Override
    @NonNull
    protected CircleSlashAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CircleSlashAttack copy() {
        return this.copyExtras(new CircleSlashAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<CircleSlashAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CircleSlashAttack>, CircleSlashAttack> buildCodec(RecordCodecBuilder.Instance<CircleSlashAttack> instance) {
            return this.attackDefault(instance, CircleSlashAttack::new);
        }
    }
}

