/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractChargeAttack;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.world.entity.LivingEntity;

public final class CleaveAttack
extends AbstractSimpleAttack<CleaveAttack, SilverChariotEntity> {
    public CleaveAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_2;
    }

    @Override
    @NonNull
    public MoveType<CleaveAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SilverChariotEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUserOrThrow();
        AbstractChargeAttack.prepDetachmentMove(attacker, user);
        attacker.setFreePos(user.m_20182_().m_82549_(attacker.getUserOrThrow().m_20154_().m_82490_(1.5)).m_252839_());
        attacker.setFree(true);
    }

    @Override
    @NonNull
    protected CleaveAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CleaveAttack copy() {
        return this.copyExtras(new CleaveAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<CleaveAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CleaveAttack>, CleaveAttack> buildCodec(RecordCodecBuilder.Instance<CleaveAttack> instance) {
            return this.attackDefault(instance, CleaveAttack::new);
        }
    }
}

