/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.world.entity.LivingEntity;

public final class GodOfDeathAttack
extends AbstractSimpleAttack<GodOfDeathAttack, SilverChariotEntity> {
    public GodOfDeathAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.SWEEP_ATTACK;
    }

    @Override
    @NonNull
    public MoveType<GodOfDeathAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(SilverChariotEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            JCraft.stun(user, 30, 1);
        } else {
            attacker.setMove(this.getFollowup(), SilverChariotEntity.State.BEAT_DOWN);
        }
        return targets;
    }

    @Override
    @NonNull
    protected GodOfDeathAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public GodOfDeathAttack copy() {
        return this.copyExtras(new GodOfDeathAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<GodOfDeathAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<GodOfDeathAttack>, GodOfDeathAttack> buildCodec(RecordCodecBuilder.Instance<GodOfDeathAttack> instance) {
            return this.attackDefault(instance, GodOfDeathAttack::new);
        }
    }
}

