/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.RapierProjectile;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class LastShotAttack
extends AbstractMove<LastShotAttack, SilverChariotEntity> {
    public LastShotAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<LastShotAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(SilverChariotEntity attacker, LivingEntity user) {
        if (!attacker.hasRapier()) {
            return Set.of();
        }
        RapierProjectile rapier = new RapierProjectile(attacker.m_9236_(), user, attacker);
        rapier.m_37251_((Entity)attacker, user.m_146909_(), user.m_146908_(), 0.0f, 2.0f, 1.0f);
        rapier.setSkin(attacker.getMode() != SilverChariotEntity.Mode.ARMORLESS ? -attacker.getMode().ordinal() : attacker.getSkin());
        attacker.m_9236_().m_7967_((Entity)rapier);
        attacker.setHasRapier(false);
        return Set.of();
    }

    @Override
    @NonNull
    protected LastShotAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LastShotAttack copy() {
        return this.copyExtras(new LastShotAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<LastShotAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<LastShotAttack>, LastShotAttack> buildCodec(RecordCodecBuilder.Instance<LastShotAttack> instance) {
            return this.baseDefault(instance, LastShotAttack::new);
        }
    }
}

