/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.minecraft.world.entity.LivingEntity;

public final class RayDartAttack
extends AbstractSimpleAttack<RayDartAttack, SilverChariotEntity> {
    public RayDartAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
        this.mobilityType = MobilityType.DASH;
    }

    @Override
    @NonNull
    public MoveType<RayDartAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SilverChariotEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUser();
        if (user != null && user.m_20096_()) {
            user.m_20256_(user.m_20184_().m_82549_(RayDartAttack.getRotVec(attacker).m_82490_(1.0)));
            user.f_19864_ = true;
        }
    }

    @Override
    @NonNull
    protected RayDartAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public RayDartAttack copy() {
        return this.copyExtras(new RayDartAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<RayDartAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RayDartAttack>, RayDartAttack> buildCodec(RecordCodecBuilder.Instance<RayDartAttack> instance) {
            return this.attackDefault(instance, RayDartAttack::new);
        }
    }
}

