/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractChargeAttack;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.minecraft.world.phys.Vec3;

public final class SCChargeAttack
extends AbstractChargeAttack<SCChargeAttack, SilverChariotEntity, SilverChariotEntity.State> {
    private Vec3 lookDir;

    public SCChargeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, SilverChariotEntity.State.P_CHARGE_HIT);
    }

    @Override
    @NonNull
    public MoveType<SCChargeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SilverChariotEntity attacker) {
        super.onInitiate(attacker);
        this.lookDir = attacker.getUserOrThrow().m_20154_();
    }

    @Override
    protected Vec3 advanceChargePos(StandEntity<?, ?> attacker, float moveDistance, int windupPoint) {
        return attacker.m_20182_().m_82549_(this.lookDir.m_82490_((double)(moveDistance / (float)windupPoint)));
    }

    @Override
    @NonNull
    protected SCChargeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SCChargeAttack copy() {
        return this.copyExtras(new SCChargeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public Vec3 getLookDir() {
        return this.lookDir;
    }

    public void setLookDir(Vec3 lookDir) {
        this.lookDir = lookDir;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SCChargeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SCChargeAttack>, SCChargeAttack> buildCodec(RecordCodecBuilder.Instance<SCChargeAttack> instance) {
            return this.attackDefault(instance, SCChargeAttack::new);
        }
    }
}

