/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class SCCounterAttack
extends AbstractCounterAttack<SCCounterAttack, SilverChariotEntity> {
    private final CounterMissMove<SilverChariotEntity> counterMiss = new CounterMissMove(20);

    public SCCounterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<SCCounterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void whiff(@NonNull SilverChariotEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(this.counterMiss, SilverChariotEntity.State.COUNTER_MISS);
        JCraft.stun(user, this.counterMiss.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull SilverChariotEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (!(countered instanceof LivingEntity)) {
            return;
        }
        LivingEntity ent = (LivingEntity)countered;
        JCraft.stun(ent, 30, 0);
        JUtils.cancelMoves(ent);
    }

    @Override
    @NonNull
    protected SCCounterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SCCounterAttack copy() {
        return this.copyExtras(new SCCounterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<SCCounterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SCCounterAttack>, SCCounterAttack> buildCodec(RecordCodecBuilder.Instance<SCCounterAttack> instance) {
            return this.baseDefault(instance, SCCounterAttack::new);
        }
    }
}

