/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.silverchariot;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class SpinBarrageAttack
extends AbstractBarrageAttack<SpinBarrageAttack, SilverChariotEntity> {
    public SpinBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
    }

    @Override
    @NonNull
    public MoveType<SpinBarrageAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SilverChariotEntity attacker) {
        LivingEntity user = attacker.getUser();
        if (user != null) {
            ItemStack mainHand = user.m_21205_();
            ItemStack offHand = user.m_21206_();
            if (mainHand.m_150930_((Item)JItemRegistry.ANUBIS.get())) {
                attacker.m_21008_(InteractionHand.OFF_HAND, mainHand.m_41777_());
                mainHand.m_41774_(1);
                return;
            }
            if (offHand.m_150930_((Item)JItemRegistry.ANUBIS.get())) {
                attacker.m_21008_(InteractionHand.OFF_HAND, offHand.m_41777_());
                offHand.m_41774_(1);
                return;
            }
        }
        super.onInitiate(attacker);
    }

    @Override
    public void onCancel(SilverChariotEntity attacker) {
        this.giveBack(attacker);
        super.onCancel(attacker);
    }

    @Override
    public void activeTick(SilverChariotEntity attacker, int moveStun) {
        if (moveStun == 1) {
            this.giveBack(attacker);
        }
        super.activeTick(attacker, moveStun);
    }

    private void giveBack(SilverChariotEntity attacker) {
        LivingEntity user = attacker.getUser();
        ItemStack itemStack = attacker.m_21206_();
        if (user != null && !itemStack.m_41619_()) {
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                serverPlayer.m_36356_(itemStack);
            } else {
                user.m_21008_(InteractionHand.MAIN_HAND, itemStack.m_41777_());
            }
            itemStack.m_41774_(1);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(SilverChariotEntity attacker, LivingEntity user) {
        return super.perform(attacker, user);
    }

    @Override
    @NonNull
    protected SpinBarrageAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SpinBarrageAttack copy() {
        return this.copyExtras(new SpinBarrageAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval()));
    }

    public static class Type
    extends AbstractBarrageAttack.Type<SpinBarrageAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SpinBarrageAttack>, SpinBarrageAttack> buildCodec(RecordCodecBuilder.Instance<SpinBarrageAttack> instance) {
            return this.barrageDefault(instance, SpinBarrageAttack::new);
        }
    }
}

