/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.starplatinum;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.AbstractStarPlatinumEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BlockBreakingAttack
extends AbstractSimpleAttack<BlockBreakingAttack, AbstractStarPlatinumEntity<?, ?>> {
    public BlockBreakingAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    public void performHook(AbstractStarPlatinumEntity<?, ?> attacker, Set<LivingEntity> targets, Set<AABB> boxes, DamageSource damageSource, Vec3 forwardPos, Vec3 rotationVector) {
        Level world = attacker.m_9236_();
        if (world.m_46469_().m_46207_(JCraft.STAND_GRIEFING)) {
            BlockPos bPos = attacker.m_20183_().m_7918_((int)rotationVector.f_82479_, (int)rotationVector.f_82480_, (int)rotationVector.f_82481_);
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        BlockPos curPos = bPos.m_7918_(x, y, z);
                        BlockState curState = world.m_8055_(curPos);
                        Block block = curState.m_60734_();
                        if (block.m_155943_() < 0.0f || block.m_7325_() > 10.0f || curState.m_60795_()) continue;
                        world.m_5898_(null, 2001, curPos, Block.m_49956_((BlockState)curState));
                        FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)world, (BlockPos)curPos, (BlockState)curState);
                        fallingBlock.m_20256_(rotationVector.m_82520_((double)x * 0.5, 0.5, (double)z * 0.5));
                        fallingBlock.f_31942_ = -120;
                        fallingBlock.f_19864_ = true;
                        fallingBlock.f_19812_ = true;
                    }
                }
            }
        }
    }

    @Override
    @NonNull
    public MoveType<BlockBreakingAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected BlockBreakingAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BlockBreakingAttack copy() {
        return this.copyExtras(new BlockBreakingAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<BlockBreakingAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BlockBreakingAttack>, BlockBreakingAttack> buildCodec(RecordCodecBuilder.Instance<BlockBreakingAttack> instance) {
            return this.attackDefault(instance, BlockBreakingAttack::new);
        }
    }
}

