/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.starplatinum;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.StarPlatinumEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class InhaleAttack
extends AbstractMove<InhaleAttack, StarPlatinumEntity> {
    private final RandomSource random = RandomSource.m_216327_();
    private final int inhaleDuration;

    public InhaleAttack(int cooldown, int windup, int duration, float moveDistance, int inhaleDuration) {
        super(cooldown, windup, duration, moveDistance);
        this.inhaleDuration = inhaleDuration;
    }

    @Override
    @NonNull
    public MoveType<InhaleAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(StarPlatinumEntity attacker) {
        this.tickInhale(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(StarPlatinumEntity attacker, LivingEntity user) {
        attacker.setInhaleTime(this.inhaleDuration);
        return Set.of();
    }

    public void tickInhale(StarPlatinumEntity attacker) {
        int inhaleTime = attacker.getInhaleTime();
        if (inhaleTime <= 0 || !attacker.hasUser()) {
            return;
        }
        if (inhaleTime % 20 == 0) {
            attacker.m_216990_((SoundEvent)JSoundRegistry.INHALE_LOOP.get());
        }
        Vec3 rotVec = attacker.getUserOrThrow().m_20154_();
        Vec3 eyePos = attacker.isFree() ? new Vec3(attacker.getFreePos()).m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, (double)attacker.m_20206_(), 0.0), GravityChangerAPI.getGravityDirection((Entity)attacker))) : attacker.m_146892_();
        Vec3 fPos = eyePos.m_82549_(rotVec.m_82490_(1.75));
        Vec3 ffPos = eyePos.m_82549_(rotVec.m_82490_(3.25));
        if (attacker.m_9236_().f_46443_) {
            Vec3 addVel = rotVec.m_82520_(this.random.m_188500_() * 2.0 - 1.0, this.random.m_188500_() * 2.0 - 1.0, this.random.m_188500_() * 2.0 - 1.0);
            Vec3 particlePos = fPos.m_82549_(addVel);
            attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, -addVel.f_82479_ / 10.0, -addVel.f_82480_ / 10.0, -addVel.f_82481_ / 10.0);
            addVel = rotVec.m_82520_(this.random.m_188500_() * 1.5 - 0.75, this.random.m_188500_() * 1.5 - 0.75, this.random.m_188500_() * 1.5 - 0.75);
            particlePos = ffPos.m_82549_(addVel);
            attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, -addVel.f_82479_ / 10.0, -addVel.f_82480_ / 10.0, -addVel.f_82481_ / 10.0);
        } else {
            attacker.setInhaleTime(--inhaleTime);
            if (inhaleTime > 0) {
                attacker.setRotationOffset(90.0f);
            } else {
                attacker.setRotationOffset(225.0f);
            }
            if (attacker.f_19797_ % 2 != 0) {
                return;
            }
            AABB fBox = AbstractSimpleAttack.createBox(fPos, 2.0);
            AABB ffBox = AbstractSimpleAttack.createBox(ffPos, 2.0);
            JUtils.displayHitbox(attacker.m_9236_(), fBox);
            JUtils.displayHitbox(attacker.m_9236_(), ffBox);
            Set<Entity> hits = AbstractSimpleAttack.findHits(attacker, Set.of(fBox, ffBox), null, Entity.class);
            for (Entity entity : hits) {
                double distance = entity.m_20182_().m_82557_(eyePos);
                if (distance > 2.0) {
                    distance -= distance * 0.1;
                }
                if (!entity.m_20096_()) {
                    distance /= 2.0;
                }
                if (distance < 0.0) {
                    distance = 0.0;
                }
                JUtils.setVelocity(entity, entity.m_20184_().m_82492_(rotVec.f_82479_, rotVec.f_82480_, rotVec.f_82481_).m_82490_(0.1 * distance));
            }
        }
    }

    @Override
    @NonNull
    protected InhaleAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public InhaleAttack copy() {
        return this.copyExtras(new InhaleAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getInhaleDuration()));
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public int getInhaleDuration() {
        return this.inhaleDuration;
    }

    public static class Type
    extends AbstractMove.Type<InhaleAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<InhaleAttack>, InhaleAttack> buildCodec(RecordCodecBuilder.Instance<InhaleAttack> instance) {
            return this.baseDefault(instance).and((App)Codec.INT.fieldOf("inhale_duration").forGetter(InhaleAttack::getInhaleDuration)).apply(instance, this.applyExtras(InhaleAttack::new));
        }
    }
}

