/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.starplatinum.theworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.entity.stand.SPTWEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class TimeStrikeAttack
extends AbstractSimpleAttack<TimeStrikeAttack, SPTWEntity> {
    private boolean turnAround = false;

    public TimeStrikeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<TimeStrikeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(SPTWEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUser();
        if (user == null) {
            return;
        }
        this.turnAround = user.m_6144_();
    }

    @Override
    public void activeTick(SPTWEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (moveStun == 7) {
            LivingEntity user = attacker.getUserOrThrow();
            Vec3 prevPos = user.m_146892_();
            TimeSkipMove.doTimeSkip(attacker, user, 2.5, List.of((SoundEvent)JSoundRegistry.STAR_PLATINUM_TIMESKIP.get()));
            if (this.turnAround) {
                user.m_7618_(EntityAnchorArgument.Anchor.EYES, prevPos);
            }
        }
    }

    @Override
    @NonNull
    protected TimeStrikeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public TimeStrikeAttack copy() {
        return this.copyExtras(new TimeStrikeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<TimeStrikeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TimeStrikeAttack>, TimeStrikeAttack> buildCodec(RecordCodecBuilder.Instance<TimeStrikeAttack> instance) {
            return this.attackDefault(instance, TimeStrikeAttack::new);
        }
    }
}

