/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class GlideMove
extends AbstractMove<GlideMove, TheFoolEntity> {
    public GlideMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.mobilityType = MobilityType.FLIGHT;
    }

    @Override
    @NonNull
    public MoveType<GlideMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void activeTick(TheFoolEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        LivingEntity user = attacker.getUser();
        if (user == null) {
            return;
        }
        user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 4, 4, true, false));
        double yVel = attacker.getRemoteJumpInput() ? 0.07 : 0.0;
        Vec3 rotVec = user.m_20154_().m_82490_(0.04);
        user.m_5997_(rotVec.f_82479_, yVel, rotVec.f_82481_);
        user.f_19864_ = true;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        attacker.setSand(false);
        return Set.of();
    }

    @Override
    public boolean preventsMoves() {
        return false;
    }

    @Override
    @NonNull
    protected GlideMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public GlideMove copy() {
        return this.copyExtras(new GlideMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<GlideMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<GlideMove>, GlideMove> buildCodec(RecordCodecBuilder.Instance<GlideMove> instance) {
            return this.baseDefault(instance, GlideMove::new);
        }
    }
}

