/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.attack.moves.thefool.SlamAttack;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class PoundAttack
extends AbstractSimpleAttack<PoundAttack, TheFoolEntity> {
    public PoundAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<PoundAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        for (LivingEntity target : targets) {
            Vec3 vel = target.m_20184_();
            target.m_20334_(vel.f_82479_, attacker.getMoveStun() > 14 ? 0.5 : -1.0, vel.f_82480_);
            target.f_19864_ = true;
        }
        return targets;
    }

    @Override
    public boolean onInitMove(TheFoolEntity attacker, MoveClass moveClass) {
        if (attacker.getMoveStun() > 11) {
            return false;
        }
        switch (moveClass) {
            case SPECIAL1: {
                this.initSlam(attacker, 1);
                break;
            }
            case SPECIAL2: {
                this.initSlam(attacker, 2);
                break;
            }
            case SPECIAL3: {
                this.initSlam(attacker, 3);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void initSlam(TheFoolEntity attacker, int type) {
        SlamAttack slam = TheFoolEntity.SLAM.copy();
        slam.setVariant(type);
        attacker.setMove((AbstractMove<?, ? super TheFoolEntity>)slam, TheFoolEntity.State.POUND_DOWN);
        attacker.m_5496_((SoundEvent)JSoundRegistry.FOOL_BARK1.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    protected PoundAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public PoundAttack copy() {
        return this.copyExtras(new PoundAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<PoundAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<PoundAttack>, PoundAttack> buildCodec(RecordCodecBuilder.Instance<PoundAttack> instance) {
            return this.attackDefault(instance, PoundAttack::new);
        }
    }
}

