/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public final class SandCloneMove
extends AbstractMove<SandCloneMove, TheFoolEntity> {
    private WeakReference<Mob> sandClone = new WeakReference<Object>(null);

    public SandCloneMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<SandCloneMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(TheFoolEntity attacker) {
        if (attacker.hasUser()) {
            this.tickClone(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Vec3 pos = user.m_146892_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(11);
        buf.writeDouble(pos.f_82479_);
        buf.writeDouble(pos.f_82480_);
        buf.writeDouble(pos.f_82481_);
        buf.writeDouble(2.0);
        Collection<ServerPlayer> nearby = JUtils.around((ServerLevel)attacker.m_9236_(), pos, 128.0);
        for (ServerPlayer serverPlayer : nearby) {
            if (serverPlayer == user || !serverPlayer.m_19950_((Entity)user, 4.0)) continue;
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, true, false));
        }
        ServerChannelFeedbackPacket.send(nearby, buf);
        Object newClone = null;
        if (user.m_6144_()) {
            for (int i = 0; i < 32; ++i) {
                double y = 0.4;
                double h = (double)i * 3.1415 / 8.0;
                double hDiv = 5.0;
                if (i >= 16) {
                    y = 0.8;
                    hDiv = 9.5;
                }
                TheFoolEntity.createFoolishSand(attacker.m_9236_(), attacker, attacker.m_20183_(), new Vec3(Math.sin(h) / hDiv, y, Math.cos(h) / hDiv));
            }
            return Set.of();
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            PlayerCloneEntity playerCloneEntity = new PlayerCloneEntity(attacker.m_9236_());
            playerCloneEntity.m_20359_((Entity)player);
            playerCloneEntity.setMaster((LivingEntity)player);
            playerCloneEntity.markSand();
            playerCloneEntity.disableDrops();
            playerCloneEntity.m_8061_(EquipmentSlot.HEAD, user.m_6844_(EquipmentSlot.HEAD).m_41777_());
            playerCloneEntity.m_8061_(EquipmentSlot.CHEST, user.m_6844_(EquipmentSlot.CHEST).m_41777_());
            playerCloneEntity.m_8061_(EquipmentSlot.LEGS, user.m_6844_(EquipmentSlot.LEGS).m_41777_());
            playerCloneEntity.m_8061_(EquipmentSlot.FEET, user.m_6844_(EquipmentSlot.FEET).m_41777_());
            newClone = playerCloneEntity;
            this.setSandClone((Mob)newClone);
        } else if (user instanceof Mob) {
            Mob mob = (Mob)user;
            newClone = JUtils.mobCloneOf(mob);
            this.setSandClone((Mob)newClone);
        }
        if (newClone != null) {
            attacker.m_9236_().m_7967_(newClone);
        }
        return Set.of();
    }

    public void tickClone(TheFoolEntity attacker) {
        Mob sandClone = (Mob)this.sandClone.get();
        if (sandClone != null && sandClone.f_19797_ > 200) {
            this.setSandClone(null);
        }
    }

    public void discardClone(TheFoolEntity attacker) {
        Mob clone = (Mob)this.sandClone.get();
        if (clone != null) {
            clone.m_146870_();
        }
    }

    private void setSandClone(Mob clone) {
        Mob currentSandClone = (Mob)this.sandClone.get();
        if (currentSandClone != null) {
            currentSandClone.m_6074_();
        }
        this.sandClone = new WeakReference<Mob>(clone);
        if (clone == null) {
            return;
        }
        JComponentPlatformUtils.getStandComponent((LivingEntity)clone).setType((StandType)JStandTypeRegistry.NONE.get());
        SandCloneMove.applySandCloneModifiers((LivingEntity)clone);
    }

    public static void applySandCloneModifiers(LivingEntity entity) {
        if (entity == null) {
            JCraft.LOGGER.error("Tried to apply sand clone attribute modifiers to invalid entity!");
            return;
        }
        AttributeInstance maxHealthAttribute = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute == null) {
            JCraft.LOGGER.error("Tried to apply sand clone attribute modifiers to entity with no max health attribute!");
            return;
        }
        maxHealthAttribute.m_22125_(new AttributeModifier("Sand Clone Max Health Modifier", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    @NonNull
    protected SandCloneMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public SandCloneMove copy() {
        return this.copyExtras(new SandCloneMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<SandCloneMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SandCloneMove>, SandCloneMove> buildCodec(RecordCodecBuilder.Instance<SandCloneMove> instance) {
            return this.baseDefault(instance, SandCloneMove::new);
        }
    }
}

