/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class SandWaveAttack
extends AbstractBarrageAttack<SandWaveAttack, TheFoolEntity> {
    private final int knockdownDuration;

    public SandWaveAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval, int knockdownDuration) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
        this.knockdownDuration = knockdownDuration;
        this.mobilityType = MobilityType.DASH;
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<SandWaveAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(TheFoolEntity attacker) {
        super.onInitiate(attacker);
        attacker.setSand(true);
        attacker.setFree(false);
        attacker.setWave(true);
    }

    @Override
    public void activeTick(TheFoolEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        LivingEntity user = attacker.getUser();
        if (user == null || !user.m_20096_()) {
            return;
        }
        Vec3 rotVec = user.m_20154_().m_82490_(0.25);
        user.m_5997_(rotVec.f_82479_, 0.0, rotVec.f_82481_);
        user.f_19864_ = true;
    }

    @Override
    protected void processTarget(TheFoolEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        int knockdownDuration = 15;
        target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), knockdownDuration, 0, true, false));
    }

    @Override
    @NonNull
    protected SandWaveAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SandWaveAttack copy() {
        return this.copyExtras(new SandWaveAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval(), this.knockdownDuration));
    }

    public int getKnockdownDuration() {
        return this.knockdownDuration;
    }

    public static class Type
    extends AbstractBarrageAttack.Type<SandWaveAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SandWaveAttack>, SandWaveAttack> buildCodec(RecordCodecBuilder.Instance<SandWaveAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.interval(), (App)ExtraCodecs.f_144628_.fieldOf("knockdown_duration").forGetter(SandWaveAttack::getKnockdownDuration)).apply(instance, this.applyAttackExtras(SandWaveAttack::new));
        }
    }
}

