/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JBlockRegistry;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class SandstormAttack
extends AbstractSimpleAttack<SandstormAttack, TheFoolEntity> {
    private WeakReference<LivingEntity> superTarget = new WeakReference<Object>(null);
    private final List<WeakReference<FallingBlockEntity>> sandEntities = new ArrayList<WeakReference<FallingBlockEntity>>();

    public SandstormAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_3;
    }

    @Override
    @NonNull
    public MoveType<SandstormAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(TheFoolEntity attacker) {
        if (attacker.hasUser()) {
            this.tickSandstorm(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return targets;
        }
        LivingEntity superTarget = JUtils.getUserIfStand((LivingEntity)targets.stream().findFirst().orElseThrow());
        this.superTarget = new WeakReference<LivingEntity>(superTarget);
        for (int i = 0; i < 8; ++i) {
            FallingBlockEntity sand = FallingBlockEntity.m_201971_((Level)attacker.m_9236_(), (BlockPos)superTarget.m_20183_(), (BlockState)((Block)JBlockRegistry.FOOLISH_SAND_BLOCK.get()).m_49966_());
            sand.f_31942_ = -160;
            sand.f_19794_ = true;
            sand.f_31943_ = false;
            sand.m_20011_(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            sand.m_20242_(true);
            this.sandEntities.add(new WeakReference<FallingBlockEntity>(sand));
        }
        return targets;
    }

    public void tickSandstorm(TheFoolEntity attacker) {
        LivingEntity superTarget = (LivingEntity)this.superTarget.get();
        if (superTarget == null) {
            return;
        }
        if (this.sandEntities.isEmpty()) {
            this.superTarget = new WeakReference<Object>(null);
            return;
        }
        if (!superTarget.m_6084_()) {
            this.superTarget = new WeakReference<Object>(null);
            this.discardSands(attacker);
            return;
        }
        superTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 0, true, false));
        superTarget.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, true, false));
        int age = attacker.f_19797_;
        if (age % 20 == 0) {
            for (int i = 0; i < this.sandEntities.size(); ++i) {
                FallingBlockEntity entity;
                WeakReference<FallingBlockEntity> entityRef = this.sandEntities.get(i);
                FallingBlockEntity fallingBlockEntity = entity = entityRef == null ? null : (FallingBlockEntity)entityRef.get();
                if (entity == null || entity.m_213877_()) {
                    this.sandEntities.remove(i);
                    --i;
                    continue;
                }
                entity.m_146870_();
                this.sandEntities.remove(i);
            }
        }
        RandomSource random = attacker.m_217043_();
        Vec3 targetPos = superTarget.m_20182_().m_82520_(0.0, (double)(superTarget.m_20206_() / 2.0f), 0.0);
        int i = 0;
        int j = 1;
        for (WeakReference<FallingBlockEntity> sandRef : this.sandEntities) {
            FallingBlockEntity sand = sandRef == null ? null : (FallingBlockEntity)sandRef.get();
            if (sand == null || sand.m_213877_()) continue;
            Vec3 newVel = sand.m_20184_().m_82490_(0.25).m_82549_(targetPos.m_82546_(sand.m_20182_().m_82520_(random.m_188500_() - 0.5 + Math.sin((double)(age * ++i) / 10.0 * (double)(j *= -1)), random.m_188500_() * 2.0 - 1.0, random.m_188500_() - 0.5 + Math.cos((double)(age * i) / 10.0 * (double)j))).m_82541_().m_82490_(0.5));
            sand.m_20256_(newVel);
            sand.f_19864_ = true;
        }
    }

    public void discardSands(TheFoolEntity attacker) {
        this.sandEntities.stream().map(Reference::get).filter(Objects::nonNull).forEach(Entity::m_146870_);
        this.sandEntities.clear();
    }

    @Override
    @NonNull
    protected SandstormAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SandstormAttack copy() {
        return this.copyExtras(new SandstormAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SandstormAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SandstormAttack>, SandstormAttack> buildCodec(RecordCodecBuilder.Instance<SandstormAttack> instance) {
            return this.attackDefault(instance, SandstormAttack::new);
        }
    }
}

