/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class SlamAttack
extends AbstractSimpleAttack<SlamAttack, TheFoolEntity> {
    private int variant = 0;

    public SlamAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<SlamAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void activeTick(TheFoolEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (this.variant != 1) {
            attacker.setQueuedMove(null);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.m_5496_((SoundEvent)JSoundRegistry.IMPACT_11.get(), 1.0f, 1.0f);
        switch (this.variant) {
            case 2: {
                Vec3 leftVec = user.m_20154_().m_82524_(1.75f);
                for (int i = 0; i < 8; ++i) {
                    leftVec = leftVec.m_82524_(-0.392699f).m_82541_();
                    TheFoolEntity.createFoolishSand(attacker.m_9236_(), attacker, attacker.m_20183_(), new Vec3(leftVec.f_82479_ / 4.0, 0.25, leftVec.f_82481_ / 4.0));
                }
                break;
            }
            case 3: {
                Vec3 rotVec = user.m_20154_();
                for (double i = 0.0; i < 7.0; i += 1.0) {
                    for (double y = 0.0; y < i; y += 1.0) {
                        double hDiv = 4.5 * (1.0 + y / i);
                        TheFoolEntity.createFoolishSand(attacker.m_9236_(), attacker, attacker.m_20183_(), new Vec3(rotVec.f_82479_ * Math.sqrt(i) / hDiv, y / 4.3, rotVec.f_82481_ * Math.sqrt(i) / hDiv));
                    }
                }
                break;
            }
        }
        return targets;
    }

    @Override
    @NonNull
    protected SlamAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SlamAttack copy() {
        return this.copyExtras(new SlamAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SlamAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SlamAttack>, SlamAttack> buildCodec(RecordCodecBuilder.Instance<SlamAttack> instance) {
            return this.attackDefault(instance, SlamAttack::new);
        }
    }
}

