/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractChargeAttack;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class TFChargeAttack
extends AbstractChargeAttack<TFChargeAttack, TheFoolEntity, TheFoolEntity.State> {
    public TFChargeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, TheFoolEntity.State.CHARGE_HIT);
    }

    @Override
    @NonNull
    public MoveType<TFChargeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return targets;
        }
        attacker.setSand(true);
        Vec3 pos = attacker.m_146892_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(11);
        buf.writeDouble(pos.f_82479_);
        buf.writeDouble(pos.f_82480_);
        buf.writeDouble(pos.f_82481_);
        buf.writeDouble(0.5);
        ServerChannelFeedbackPacket.send(JUtils.around((ServerLevel)attacker.m_9236_(), pos, 96.0), buf);
        return targets;
    }

    @Override
    @NonNull
    protected TFChargeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public TFChargeAttack copy() {
        return this.copyExtras(new TFChargeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<TFChargeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TFChargeAttack>, TFChargeAttack> buildCodec(RecordCodecBuilder.Instance<TFChargeAttack> instance) {
            return this.attackDefault(instance, TFChargeAttack::new);
        }
    }
}

