/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thefool;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.TheFoolEntity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public final class TFComboAttack
extends AbstractMultiHitAttack<TFComboAttack, TheFoolEntity> {
    public TFComboAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public MoveType<TFComboAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheFoolEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (this.getBlow(attacker) == 2) {
            for (LivingEntity ent : targets) {
                ent.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 20, 0, true, false));
            }
        }
        return targets;
    }

    @Override
    @NonNull
    protected TFComboAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public TFComboAttack copy() {
        return this.copyExtras(new TFComboAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<TFComboAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TFComboAttack>, TFComboAttack> buildCodec(RecordCodecBuilder.Instance<TFComboAttack> instance) {
            return this.multiHitDefault(instance, TFComboAttack::new);
        }
    }
}

