/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thehand;

import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.TheHandEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEraseAttack<T extends AbstractEraseAttack<T>>
extends AbstractSimpleAttack<T, TheHandEntity> {
    public AbstractEraseAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.withBlockableType(BlockableType.NON_BLOCKABLE);
        this.withHitSpark(JParticleType.INVERTED_HIT_SPARK_3);
    }

    @Override
    protected void processTarget(TheHandEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        Attacks.damageLogic(attacker.getEntityWorld(), target, kbVec, this.getStun(), this.getStunType().ordinal(), true, 0.0f, this.isLift(), this.getBlockStun(), damageSource, (Entity)attacker.getUserOrThrow(), this.getHitAnimation(), true, true);
        target.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
        StandEntity<?, ?> stand = JUtils.getStand(target);
        if (stand != null) {
            stand.blocking = false;
        }
        JCraft.stun(target, this.getStun(), 0, (Entity)attacker);
        Attacks.trueDamage(this.getDamage(), JDamageSources.stand(attacker), target);
    }
}

