/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thehand;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.attack.moves.thehand.AbstractEraseAttack;
import net.arna.jcraft.common.entity.stand.TheHandEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class EraseGroundAttack
extends AbstractEraseAttack<EraseGroundAttack> {
    public EraseGroundAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<EraseGroundAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheHandEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Level level = user.m_9236_();
        if (!this.mayGrief(user)) {
            return targets;
        }
        Vec3 rotVec = attacker.m_20154_();
        Vec3i rotVecI = new Vec3i((int)Math.round(rotVec.f_82479_), (int)Math.round(rotVec.f_82480_), (int)Math.round(rotVec.f_82481_));
        Vec3i gravityNormal = GravityChangerAPI.getGravityDirection((Entity)user).m_122436_();
        BlockPos lowBlock1 = attacker.m_20097_();
        BlockPos lowBlock2 = lowBlock1.m_121955_(rotVecI);
        BlockPos block1 = lowBlock1.m_121996_(gravityNormal);
        BlockPos block2 = block1.m_121955_(rotVecI);
        BlockPos block3 = block2.m_121955_(rotVecI);
        EraseGroundAttack.eraseBlock(level, lowBlock1);
        EraseGroundAttack.eraseBlock(level, lowBlock2);
        EraseGroundAttack.eraseBlock(level, block1);
        EraseGroundAttack.eraseBlock(level, block2);
        EraseGroundAttack.eraseBlock(level, block3);
        return targets;
    }

    private static void eraseBlock(Level level, BlockPos lookedBlock) {
        if (level.m_8055_(lookedBlock).m_60734_().m_155943_() <= 0.0f) {
            return;
        }
        level.m_7731_(lookedBlock, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    @NonNull
    protected EraseGroundAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public EraseGroundAttack copy() {
        return this.copyExtras(new EraseGroundAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<EraseGroundAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<EraseGroundAttack>, EraseGroundAttack> buildCodec(RecordCodecBuilder.Instance<EraseGroundAttack> instance) {
            return this.attackDefault(instance, EraseGroundAttack::new);
        }
    }
}

