/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thehand;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.attack.moves.thehand.AbstractEraseAttack;
import net.arna.jcraft.common.entity.stand.TheHandEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EraseSpaceAttack
extends AbstractEraseAttack<EraseSpaceAttack> {
    public EraseSpaceAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.mobilityType = MobilityType.DASH;
    }

    @Override
    @NonNull
    public MoveType<EraseSpaceAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheHandEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Vec3 rotVec = user.m_20154_();
        Vec3 eyePos = user.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)user));
        HitResult hitResult = JUtils.raycastAll((Entity)attacker, eyePos, eyePos.m_82549_(rotVec.m_82490_(16.0)), ClipContext.Fluid.NONE);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity hitEntity = JUtils.getUserIfStand(((EntityHitResult)hitResult).m_82443_());
            JUtils.addVelocity(hitEntity, rotVec.m_82490_(-1.25));
            hitEntity.m_6853_(false);
            if (hitEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)hitEntity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 0, true, false));
            }
        } else {
            JUtils.addVelocity((Entity)user, rotVec.m_82490_(1.25));
        }
        return targets;
    }

    @Override
    @NonNull
    protected EraseSpaceAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public EraseSpaceAttack copy() {
        return this.copyExtras(new EraseSpaceAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<EraseSpaceAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<EraseSpaceAttack>, EraseSpaceAttack> buildCodec(RecordCodecBuilder.Instance<EraseSpaceAttack> instance) {
            return this.attackDefault(instance, EraseSpaceAttack::new);
        }
    }
}

