/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thehand;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.moves.shared.BarrageAttack;
import net.arna.jcraft.common.attack.moves.thehand.SimpleEraseAttack;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.TheHandEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class RageAttack
extends AbstractMultiHitAttack<RageAttack, TheHandEntity> {
    public static final SimpleEraseAttack RAGE_FINISHER = (SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)new SimpleEraseAttack(0, 41, 50, 0.74f, 6.0f, 12, 2.0f, 2.0f, 0.0f).withSound(JSoundRegistry.D4C_LIGHT)).withImpactSound(JSoundRegistry.IMPACT_12)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withExtraHitBox(1.5)).withInfo((Component)Component.m_237113_((String)"Rage (Finisher)"), (Component)Component.m_237119_())).withLaunch();
    public static final BarrageAttack<TheHandEntity> RAGE_FOLLOWUP = (BarrageAttack)((BarrageAttack)((BarrageAttack)new BarrageAttack(0, 9, 50, 0.75f, 1.0f, 13, 1.75f, 0.2f, 0.0f, 2).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Rage (Barrage)"), (Component)Component.m_237119_())).withFinisher(29, RAGE_FINISHER);

    public RageAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, IntSet hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, (IntCollection)hitMoments);
        this.withBlockableType(BlockableType.NON_BLOCKABLE);
        this.withHitSpark(JParticleType.INVERTED_HIT_SPARK_3);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheHandEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty() || this.getBlow(attacker) != 1) {
            return targets;
        }
        attacker.setMove(RAGE_FOLLOWUP, TheHandEntity.State.RAGE_FOLLOWUP);
        return targets;
    }

    @Override
    protected void processTarget(TheHandEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        Attacks.damageLogic(attacker.getEntityWorld(), target, kbVec, this.getStun(), this.getStunType().ordinal(), true, 0.0f, this.isLift(), this.getBlockStun(), damageSource, (Entity)attacker.getUserOrThrow(), this.getHitAnimation(), true, false);
        target.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
        StandEntity<?, ?> stand = JUtils.getStand(target);
        if (stand != null) {
            stand.blocking = false;
        }
        JCraft.stun(target, this.getStun(), 0, (Entity)attacker);
        Attacks.trueDamage(this.getDamage(), JDamageSources.stand(attacker), target);
    }

    @Override
    @NonNull
    public MoveType<RageAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected RageAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public RageAttack copy() {
        return this.copyExtras(new RageAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntSet)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<RageAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RageAttack>, RageAttack> buildCodec(RecordCodecBuilder.Instance<RageAttack> instance) {
            return this.multiHitDefault(instance, RageAttack::new);
        }
    }
}

