/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thehand;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractUppercutAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.TheHandEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class Stomp2Attack
extends AbstractUppercutAttack<Stomp2Attack, TheHandEntity> {
    public Stomp2Attack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, float strength) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, strength);
    }

    @Override
    @NonNull
    public MoveType<Stomp2Attack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheHandEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        JComponentPlatformUtils.getShockwaveHandler(attacker.m_9236_()).addShockwave(attacker.m_20182_().m_82549_(user.m_20154_()), new Vec3(GravityChangerAPI.getGravityDirection((Entity)attacker).m_253071_()), 2.5f);
        targets.forEach(livingEntity -> livingEntity.m_21195_((MobEffect)JStatusRegistry.KNOCKDOWN.get()));
        return targets;
    }

    @Override
    @NonNull
    protected Stomp2Attack getThis() {
        return this;
    }

    @Override
    @NonNull
    public Stomp2Attack copy() {
        return this.copyExtras(new Stomp2Attack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getStrength()));
    }

    public static class Type
    extends AbstractUppercutAttack.Type<Stomp2Attack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<Stomp2Attack>, Stomp2Attack> buildCodec(RecordCodecBuilder.Instance<Stomp2Attack> instance) {
            return this.uppercutDefault(instance, Stomp2Attack::new);
        }
    }
}

