/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thesun;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.MeteorProjectile;
import net.arna.jcraft.common.entity.stand.TheSunEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class FireMeteorAttack
extends AbstractMove<FireMeteorAttack, TheSunEntity> {
    private final int meteors;
    private final float meteorVelocity;
    private final float meteorSpeed;
    private final float meteorDivergence;
    private final boolean explosiveIfMax;
    @NonNull
    private final IntCollection hitMoments;
    private Vec3 targetPosition;

    public FireMeteorAttack(int cooldown, int duration, int meteors, float meteorVelocity, float meteorSpeed, float meteorDivergence, boolean explosiveIfMax, @NonNull IntCollection hitMoments) {
        super(cooldown, hitMoments.intStream().min().orElse(duration + 1), duration, 0.0f);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
        this.meteors = meteors;
        this.meteorVelocity = meteorVelocity;
        this.meteorSpeed = meteorSpeed;
        this.meteorDivergence = meteorDivergence;
        this.explosiveIfMax = explosiveIfMax;
        this.hitMoments = new IntImmutableList(hitMoments.intStream().sorted().toArray());
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<FireMeteorAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean shouldPerform(TheSunEntity attacker, int moveStun) {
        return attacker.hasUser() && this.hitMoments.contains(this.getDuration() - attacker.getMoveStun());
    }

    @Override
    public void onInitiate(TheSunEntity attacker) {
        super.onInitiate(attacker);
        this.targetPosition = attacker.acquireTargetPosition();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheSunEntity attacker, LivingEntity user) {
        Vec3 pos = attacker.randomPos();
        for (int i = 0; i < this.meteors; ++i) {
            MeteorProjectile meteor = FireMeteorAttack.fireMeteor(attacker, user, pos, JUtils.getLookVector(pos, this.targetPosition).m_82490_((double)this.meteorVelocity), this.meteorSpeed, this.meteorDivergence);
            meteor.m_20242_(true);
            if (!this.explosiveIfMax || attacker.getRawScale() != 3.0f) continue;
            meteor.setExplosive(true);
        }
        return Set.of();
    }

    public static MeteorProjectile fireMeteor(TheSunEntity attacker, @NonNull LivingEntity user, Vec3 pos, Vec3 velocity) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return FireMeteorAttack.fireMeteor(attacker, user, pos, velocity, 1.25f, 10.0f);
    }

    public static MeteorProjectile fireMeteor(TheSunEntity attacker, @NonNull LivingEntity user, Vec3 pos, Vec3 velocity, float speed, float divergence) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        MeteorProjectile meteor = new MeteorProjectile(attacker.m_9236_(), user, attacker);
        meteor.setSkin(attacker.getSkin());
        meteor.m_146884_(pos);
        meteor.m_6686_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, speed, divergence);
        attacker.m_9236_().m_7967_((Entity)meteor);
        AbstractMove move = attacker.getCurrentMove();
        if (move != null && !move.isBarrage()) {
            attacker.m_5496_((SoundEvent)JSoundRegistry.SUN_METEOR_FIRE.get(), 1.0f, 1.0f);
        }
        return meteor;
    }

    @Override
    @NonNull
    protected FireMeteorAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FireMeteorAttack copy() {
        return this.copyExtras(new FireMeteorAttack(this.getCooldown(), this.getDuration(), this.meteors, this.meteorVelocity, this.meteorSpeed, this.meteorDivergence, this.explosiveIfMax, this.hitMoments));
    }

    public int getMeteors() {
        return this.meteors;
    }

    public float getMeteorVelocity() {
        return this.meteorVelocity;
    }

    public float getMeteorSpeed() {
        return this.meteorSpeed;
    }

    public float getMeteorDivergence() {
        return this.meteorDivergence;
    }

    public boolean isExplosiveIfMax() {
        return this.explosiveIfMax;
    }

    @NonNull
    public IntCollection getHitMoments() {
        return this.hitMoments;
    }

    public static class Type
    extends AbstractMove.Type<FireMeteorAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FireMeteorAttack>, FireMeteorAttack> buildCodec(RecordCodecBuilder.Instance<FireMeteorAttack> instance) {
            return instance.group(this.extras(), this.cooldown(), this.duration(), (App)Codec.INT.fieldOf("meteors").forGetter(FireMeteorAttack::getMeteors), (App)Codec.FLOAT.fieldOf("meteor_velocity").forGetter(FireMeteorAttack::getMeteorVelocity), (App)Codec.FLOAT.fieldOf("meteor_speed").forGetter(FireMeteorAttack::getMeteorSpeed), (App)Codec.FLOAT.fieldOf("meteor_divergence").forGetter(FireMeteorAttack::getMeteorDivergence), (App)Codec.BOOL.fieldOf("explosive_if_max").forGetter(FireMeteorAttack::isExplosiveIfMax), (App)ExtraCodecs.f_144628_.listOf().xmap(IntOpenHashSet::new, ArrayList::new).fieldOf("hit_moments").forGetter(FireMeteorAttack::getHitMoments)).apply(instance, this.applyExtras(FireMeteorAttack::new));
        }
    }
}

