/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.thesun;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.SunBeamProjectile;
import net.arna.jcraft.common.entity.stand.TheSunEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;

public class FireSunBeamAttack
extends AbstractMove<FireSunBeamAttack, TheSunEntity> {
    private final int beams;
    private final float divergence;
    private Vec3 targetPosition;

    public FireSunBeamAttack(int cooldown, int windup, int duration, int beams, float divergence) {
        super(cooldown, windup, duration, 0.0f);
        this.beams = beams;
        this.divergence = divergence;
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<FireSunBeamAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(TheSunEntity attacker) {
        super.onInitiate(attacker);
        this.targetPosition = attacker.acquireTargetPosition();
    }

    @Override
    public boolean shouldPerform(TheSunEntity attacker, int moveStun) {
        return attacker.hasUser() && moveStun <= this.getWindupPoint() && (this.getWindupPoint() - moveStun) / 4 < this.beams && (this.getWindupPoint() - moveStun) % 4 == 0;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheSunEntity attacker, LivingEntity user) {
        Vec3 pos = attacker.randomPos();
        SunBeamProjectile sunBeam = new SunBeamProjectile(attacker.m_9236_(), user, attacker);
        sunBeam.setSkin(attacker.getSkin());
        sunBeam.m_146884_(pos);
        Vector2f pitchYaw = JUtils.getLookPY(pos, this.targetPosition);
        float pitch = pitchYaw.x;
        float yaw = pitchYaw.y;
        Vec3 lookVec = new Vec3((double)(-Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)))), (double)(-Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)))), (double)(Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)))));
        sunBeam.m_146926_(pitch + (attacker.m_217043_().m_188501_() - 0.5f) * this.divergence);
        sunBeam.m_146922_(yaw + (attacker.m_217043_().m_188501_() - 0.5f) * this.divergence);
        sunBeam.m_6686_(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_, 0.01f, this.divergence);
        attacker.m_9236_().m_7967_((Entity)sunBeam);
        attacker.m_5496_((SoundEvent)JSoundRegistry.SUN_BEAM_RAY.get(), 1.0f, 1.0f);
        return Set.of();
    }

    @Override
    @NonNull
    protected FireSunBeamAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FireSunBeamAttack copy() {
        return this.copyExtras(new FireSunBeamAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.beams, this.divergence));
    }

    public int getBeams() {
        return this.beams;
    }

    public float getDivergence() {
        return this.divergence;
    }

    public static class Type
    extends AbstractMove.Type<FireSunBeamAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FireSunBeamAttack>, FireSunBeamAttack> buildCodec(RecordCodecBuilder.Instance<FireSunBeamAttack> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration(), (App)Codec.INT.fieldOf("beams").forGetter(FireSunBeamAttack::getBeams), (App)Codec.FLOAT.fieldOf("divergence").forGetter(FireSunBeamAttack::getDivergence)).apply(instance, this.applyExtras(FireSunBeamAttack::new));
        }
    }
}

