/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.core.itfs.AttackRotationOffsetOverride;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.TheWorldEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class FeignBarrageCounterAttack
extends AbstractCounterAttack<FeignBarrageCounterAttack, TheWorldEntity>
implements AttackRotationOffsetOverride {
    private static final CounterMissMove<TheWorldEntity> missAttack = new CounterMissMove(10);
    private final AbstractMove<?, ? super TheWorldEntity> hitMove;

    public FeignBarrageCounterAttack(int cooldown, int windup, int duration, float moveDistance, AbstractMove<?, ? super TheWorldEntity> hitMove) {
        super(cooldown, windup, duration, moveDistance);
        this.hitMove = hitMove;
    }

    @Override
    public void whiff(@NonNull TheWorldEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(missAttack, TheWorldEntity.State.COUNTER_MISS);
        JCraft.stun(user, missAttack.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull TheWorldEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (countered == null || !attacker.hasUser()) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        Vec3 behind = countered.m_20182_().m_82546_(countered.m_20154_());
        BlockPos behindBlockPos = new BlockPos((int)behind.f_82479_, (int)behind.f_82480_, (int)behind.f_82481_);
        JUtils.setVelocity((Entity)user, 0.0, 0.0, 0.0);
        if (!user.m_9236_().m_8055_(behindBlockPos).m_60815_()) {
            user.m_20324_(behind.f_82479_, behind.f_82480_, behind.f_82481_);
        }
        user.m_7618_(EntityAnchorArgument.Anchor.EYES, countered.m_146892_());
        if (countered instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)countered;
            livingEntity.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            JCraft.stun(livingEntity, 20, 0);
            JUtils.cancelMoves(livingEntity);
        }
        attacker.setMove(this.hitMove, TheWorldEntity.State.COUNTER_HIT);
        attacker.m_5496_((SoundEvent)JSoundRegistry.TIME_SKIP.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    public MoveType<FeignBarrageCounterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected FeignBarrageCounterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FeignBarrageCounterAttack copy() {
        return this.copyExtras(new FeignBarrageCounterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.hitMove));
    }

    @Override
    public float getAttackRotationOffset(StandEntity<?, ?> attacker) {
        return attacker.getMoveStun() > this.getWindupPoint() ? attacker.getStandData().getIdleRotation() : 90.0f;
    }

    public AbstractMove<?, ? super TheWorldEntity> getHitMove() {
        return this.hitMove;
    }

    public static class Type
    extends AbstractMove.Type<FeignBarrageCounterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FeignBarrageCounterAttack>, FeignBarrageCounterAttack> buildCodec(RecordCodecBuilder.Instance<FeignBarrageCounterAttack> instance) {
            return this.baseDefault(instance).and((App)JRegistries.MOVE_CODEC.fieldOf("hit_move").xmap(m -> m, m -> m).forGetter(FeignBarrageCounterAttack::getHitMove)).apply(instance, this.applyExtras(FeignBarrageCounterAttack::new));
        }
    }
}

