/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.TheWorldEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public final class TWDonutAttack
extends AbstractSimpleAttack<TWDonutAttack, TheWorldEntity> {
    public TWDonutAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_3;
    }

    @Override
    @NonNull
    public MoveType<TWDonutAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheWorldEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            JCraft.stun(user, 30, 0);
        }
        return targets;
    }

    @Override
    public void activeTick(TheWorldEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (attacker.hasUser() && !attacker.isRemote()) {
            attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 2, true, false));
        }
    }

    @Override
    @NonNull
    protected TWDonutAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public TWDonutAttack copy() {
        return this.copyExtras(new TWDonutAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<TWDonutAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TWDonutAttack>, TWDonutAttack> buildCodec(RecordCodecBuilder.Instance<TWDonutAttack> instance) {
            return this.attackDefault(instance, TWDonutAttack::new);
        }
    }
}

