/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;

public final class AerialDivineFinisherAttack
extends AbstractSimpleAttack<AerialDivineFinisherAttack, TheWorldOverHeavenEntity> {
    public AerialDivineFinisherAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<AerialDivineFinisherAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(TheWorldOverHeavenEntity attacker) {
        super.onInitiate(attacker);
        attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 10, 2, true, false));
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheWorldOverHeavenEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Vec3 heightOffset = this.getOffsetHeightPos(attacker);
        RandomSource random = attacker.m_217043_();
        for (int i = 0; i < 8; ++i) {
            KnifeProjectile knife = new KnifeProjectile(attacker.m_9236_(), user);
            knife.setLightning(true);
            knife.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            knife.explosive = true;
            knife.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 2.0f - (float)i / 8.0f, 1.0f);
            knife.m_146884_(heightOffset.m_82520_(random.m_216328_(0.0, 0.5), random.m_216328_(0.0, 0.5), random.m_216328_(0.0, 0.5)));
            attacker.m_9236_().m_7967_((Entity)knife);
        }
        return targets;
    }

    @Override
    @NonNull
    protected AerialDivineFinisherAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public AerialDivineFinisherAttack copy() {
        return this.copyExtras(new AerialDivineFinisherAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<AerialDivineFinisherAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<AerialDivineFinisherAttack>, AerialDivineFinisherAttack> buildCodec(RecordCodecBuilder.Instance<AerialDivineFinisherAttack> instance) {
            return this.attackDefault(instance, AerialDivineFinisherAttack::new);
        }
    }
}

