/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;

public class ChargeOverwriteMove
extends AbstractMove<ChargeOverwriteMove, TheWorldOverHeavenEntity> {
    private final int minChargeTime;

    public ChargeOverwriteMove(int cooldown, int windup, int duration, float moveDistance, int minChargeTime) {
        super(cooldown, windup, duration, moveDistance);
        this.minChargeTime = minChargeTime;
    }

    @Override
    @NonNull
    public MoveType<ChargeOverwriteMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheWorldOverHeavenEntity attacker, LivingEntity user) {
        return Set.of();
    }

    @Override
    public boolean onInitMove(TheWorldOverHeavenEntity attacker, MoveClass moveClass) {
        if (attacker.getMoveStun() >= this.getDuration() - this.minChargeTime) {
            return false;
        }
        switch (moveClass) {
            case SPECIAL1: {
                this.initFollowup(attacker, 1);
                break;
            }
            case SPECIAL2: {
                this.initFollowup(attacker, 2);
                break;
            }
            case SPECIAL3: {
                this.initFollowup(attacker, 3);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void initFollowup(TheWorldOverHeavenEntity attacker, int type) {
        attacker.setOverwriteType(type);
        attacker.getMoveMap().initiateFollowup(attacker, this, false, 0);
        attacker.m_5496_((SoundEvent)JSoundRegistry.TWOH_OVERWRITE.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    protected ChargeOverwriteMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public ChargeOverwriteMove copy() {
        return this.copyExtras(new ChargeOverwriteMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.minChargeTime));
    }

    public int getMinChargeTime() {
        return this.minChargeTime;
    }

    public static class Type
    extends AbstractMove.Type<ChargeOverwriteMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ChargeOverwriteMove>, ChargeOverwriteMove> buildCodec(RecordCodecBuilder.Instance<ChargeOverwriteMove> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), (App)ExtraCodecs.f_144628_.fieldOf("min_charge_time").forGetter(ChargeOverwriteMove::getMinChargeTime)).apply(instance, this.applyExtras(ChargeOverwriteMove::new));
        }
    }
}

