/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;

public final class DivineFinisherAttack
extends AbstractSimpleAttack<DivineFinisherAttack, TheWorldOverHeavenEntity> {
    public DivineFinisherAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<DivineFinisherAttack> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheWorldOverHeavenEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Vec3 rotVec = user.m_20154_();
        for (int i = 0; i < 4; ++i) {
            KnifeProjectile knife = new KnifeProjectile(attacker.m_9236_(), user);
            knife.setDelayedLightning(10 + i * 5);
            knife.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            knife.m_20242_(true);
            knife.m_20256_(new Vec3(rotVec.f_82479_ * 0.7, 0.0, rotVec.f_82481_ * 0.7).m_82524_(1.5708f * (float)i));
            knife.m_146884_(attacker.m_146892_());
            attacker.m_9236_().m_7967_((Entity)knife);
        }
        return targets;
    }

    @Override
    @NonNull
    protected DivineFinisherAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public DivineFinisherAttack copy() {
        return this.copyExtras(new DivineFinisherAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<DivineFinisherAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<DivineFinisherAttack>, DivineFinisherAttack> buildCodec(RecordCodecBuilder.Instance<DivineFinisherAttack> instance) {
            return this.attackDefault(instance, DivineFinisherAttack::new);
        }
    }
}

