/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;

public final class LungeAttack
extends AbstractSimpleAttack<LungeAttack, StandEntity<?, ?>> {
    private final float originalMoveDistance;
    private final int beginMoveStun;
    private final int endMoveStun;

    public LungeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int beginMoveStun, int endMoveStun) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.originalMoveDistance = moveDistance;
        this.beginMoveStun = beginMoveStun;
        this.endMoveStun = endMoveStun;
        if (endMoveStun >= beginMoveStun) {
            throw new IllegalStateException("End movestun must be smaller than starting!");
        }
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<LungeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(StandEntity<?, ?> attacker) {
        super.onInitiate(attacker);
        this.withMoveDistance(this.originalMoveDistance);
    }

    @Override
    public void activeTick(StandEntity<?, ?> attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (moveStun > this.endMoveStun && moveStun <= this.beginMoveStun) {
            this.withMoveDistance(this.getMoveDistance() + 0.15f);
        }
    }

    public LungeAttack withCrouchingVariant(KnockdownAttack<? extends StandEntity<?, ?>> crouchingVariant) {
        return (LungeAttack)super.withCrouchingVariant(crouchingVariant);
    }

    @Override
    @NonNull
    protected LungeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LungeAttack copy() {
        return this.copyExtras(new LungeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.originalMoveDistance, this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.beginMoveStun, this.endMoveStun));
    }

    public int getBeginMoveStun() {
        return this.beginMoveStun;
    }

    public int getEndMoveStun() {
        return this.endMoveStun;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<LungeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<LungeAttack>, LungeAttack> buildCodec(RecordCodecBuilder.Instance<LungeAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)Codec.INT.fieldOf("begin_move_stun").forGetter(LungeAttack::getBeginMoveStun), (App)Codec.INT.fieldOf("end_move_stun").forGetter(LungeAttack::getEndMoveStun)).apply(instance, this.applyAttackExtras(LungeAttack::new));
        }
    }
}

