/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public final class OverwriteAttack
extends AbstractSimpleAttack<OverwriteAttack, TheWorldOverHeavenEntity> {
    public static final double NO_LOOK_RANGE = 512.0;
    private final List<Overwrite> overwrites = new ArrayList<Overwrite>();

    public OverwriteAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    public void tick(TheWorldOverHeavenEntity attacker) {
        int moveStun;
        if (!attacker.hasUser()) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        RandomSource random = attacker.m_217043_();
        if (user instanceof Mob && attacker.getState() == TheWorldOverHeavenEntity.State.CHARGE_OVERWRITE && random.m_188499_()) {
            attacker.initMove(random.m_188499_() ? MoveClass.SPECIAL1 : MoveClass.SPECIAL2);
        }
        if ((moveStun = attacker.getMoveStun()) <= 0 && attacker.getOverwriteType() != 0) {
            attacker.setOverwriteType(0);
        }
        this.overwrites.removeIf(Overwrite::isInvalid);
        for (Overwrite overwrite : this.overwrites) {
            Entity lookEntity;
            overwrite.tick();
            LivingEntity entity = overwrite.getEntity();
            if (JUtils.isBlocking(entity)) {
                return;
            }
            AABB box = entity.m_20191_().m_82369_(entity.m_20252_(1.0f).m_82490_(512.0)).m_82400_(1.0);
            EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)entity.m_146892_(), (Vec3)entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(512.0)), (AABB)box, (Predicate)EntitySelector.f_20406_, (double)512.0);
            if (hitResult == null || (lookEntity = hitResult.m_82443_()) != user && lookEntity != attacker) continue;
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, attacker.m_146892_().m_82520_((double)(random.m_188502_() * 10), (double)(random.m_188502_() * 10), (double)(random.m_188502_() * 10)));
        }
    }

    @Override
    protected void processTarget(TheWorldOverHeavenEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        switch (attacker.getOverwriteType()) {
            case 1: {
                this.overwrites.add(new Overwrite(target, 200));
                break;
            }
            case 2: {
                target.m_20254_(5);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 0, false, true));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0, false, true));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 0, false, true));
                break;
            }
            case 3: {
                target.m_5634_(4.0f);
                if (!(target instanceof Mob)) {
                    return;
                }
                JComponentPlatformUtils.getMiscData(target).setSlavedTo(attacker.getUserOrThrow().m_20148_());
                this.overwrites.add(new Overwrite(target, 0x100000));
            }
        }
    }

    @Override
    @NonNull
    public MoveType<OverwriteAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected OverwriteAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public OverwriteAttack copy() {
        return this.copyExtras(new OverwriteAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    private static class Overwrite {
        private final WeakReference<LivingEntity> entity;
        private int time;

        public Overwrite(LivingEntity entity, int time) {
            this.entity = new WeakReference<LivingEntity>(entity);
            this.time = time;
        }

        public void tick() {
            if (this.time > 0) {
                --this.time;
            }
        }

        public LivingEntity getEntity() {
            return (LivingEntity)this.entity.get();
        }

        public boolean isInvalid() {
            LivingEntity entity = this.getEntity();
            return entity == null || !entity.m_6084_() || this.time <= 0;
        }

        public int getTime() {
            return this.time;
        }
    }

    public static class Type
    extends AbstractSimpleAttack.Type<OverwriteAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<OverwriteAttack>, OverwriteAttack> buildCodec(RecordCodecBuilder.Instance<OverwriteAttack> instance) {
            return this.attackDefault(instance, OverwriteAttack::new);
        }
    }
}

