/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class SingularityAttack
extends AbstractSimpleAttack<SingularityAttack, TheWorldOverHeavenEntity> {
    private final boolean blockBypass;

    public SingularityAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, boolean blockBypass) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.blockBypass = blockBypass;
    }

    @Override
    protected void processTarget(TheWorldOverHeavenEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        Attacks.damageLogic(attacker.getEntityWorld(), target, new AttackData(kbVec, this.getStun(), this.getStunType().ordinal(), true, 0.0f, this.isLift(), this.getBlockStun(), damageSource, (Entity)attacker.getUserOrThrow(), this.getHitAnimation(), attacker.getMoveUsage(), true, false));
        if (this.blockBypass) {
            target.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            JCraft.stun(target, this.getStun(), 0, (Entity)attacker);
        }
        Attacks.trueDamage(6.0f, JDamageSources.stand(attacker), target);
    }

    @Override
    @NonNull
    public MoveType<SingularityAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    protected SingularityAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SingularityAttack copy() {
        return this.copyExtras(new SingularityAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.blockBypass));
    }

    public boolean isBlockBypass() {
        return this.blockBypass;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SingularityAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SingularityAttack>, SingularityAttack> buildCodec(RecordCodecBuilder.Instance<SingularityAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)Codec.BOOL.fieldOf("block_bypass").forGetter(SingularityAttack::isBlockBypass)).apply(instance, this.applyAttackExtras(SingularityAttack::new));
        }
    }
}

