/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.theworld.overheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.TheWorldOverHeavenEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public final class SmiteAttack
extends AbstractSimpleAttack<SmiteAttack, TheWorldOverHeavenEntity> {
    private final boolean aerial;
    private final int levitationDuration;
    private final int levitationAmplifier;
    private Vec3 lightningPos;
    private WeakReference<LightningBolt> bolt = new WeakReference<Object>(null);

    public SmiteAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, boolean aerial, int levitationDuration, int levitationAmplifier) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.aerial = this.ranged = aerial;
        this.levitationDuration = levitationDuration;
        this.levitationAmplifier = levitationAmplifier;
        this.withHitSpark(null);
    }

    @Override
    @NonNull
    public MoveType<SmiteAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(TheWorldOverHeavenEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUserOrThrow();
        if (!this.aerial) {
            this.lightningPos = user.m_20182_();
        } else {
            Vec3 eP = user.m_146892_();
            Vec3 rangeMod = user.m_20154_().m_82490_(24.0);
            EntityHitResult eHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)eP, (Vec3)eP.m_82549_(rangeMod), (AABB)user.m_20191_().m_82400_(24.0), (Predicate)EntitySelector.f_20406_, (double)576.0);
            this.lightningPos = Objects.requireNonNullElseGet(eHit, () -> attacker.m_9236_().m_45547_(new ClipContext(eP, eP.m_82549_(rangeMod), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user))).m_82450_();
        }
        AreaEffectCloud effectCloud = new AreaEffectCloud(attacker.m_9236_(), this.lightningPos.f_82479_, this.lightningPos.f_82480_, this.lightningPos.f_82481_);
        effectCloud.m_19718_(user);
        effectCloud.m_19712_(this.getDamage() / 2.0f);
        effectCloud.m_19740_(10);
        effectCloud.m_19738_(-0.5f);
        attacker.m_9236_().m_7967_((Entity)effectCloud);
        attacker.m_9236_().m_6263_(null, this.lightningPos.f_82479_, this.lightningPos.f_82480_, this.lightningPos.f_82481_, (SoundEvent)JSoundRegistry.TWOH_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(TheWorldOverHeavenEntity attacker, LivingEntity user) {
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, attacker.m_9236_());
        bolt.m_20874_(true);
        bolt.m_146884_(this.lightningPos);
        this.bolt = new WeakReference<LightningBolt>(bolt);
        Set<LivingEntity> targets = super.perform(attacker, user);
        attacker.m_9236_().m_7967_((Entity)bolt);
        return targets;
    }

    @Override
    protected Set<AABB> calculateBoxes(TheWorldOverHeavenEntity attacker, LivingEntity user, Vec3 rotVec, Vec3 upVec, Vec3 hPos, Vec3 fPos) {
        return Set.of(SmiteAttack.createBox(this.lightningPos, this.getHitboxSize()));
    }

    @Override
    protected void processTarget(TheWorldOverHeavenEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        LightningBolt bolt = (LightningBolt)this.bolt.get();
        if (bolt != null) {
            target.m_8038_((ServerLevel)attacker.m_9236_(), bolt);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, this.levitationDuration, this.levitationAmplifier, true, false));
        }
    }

    @Override
    @NonNull
    protected SmiteAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SmiteAttack copy() {
        return this.copyExtras(new SmiteAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.isAerial(), this.levitationDuration, this.levitationAmplifier));
    }

    public boolean isAerial() {
        return this.aerial;
    }

    public int getLevitationDuration() {
        return this.levitationDuration;
    }

    public int getLevitationAmplifier() {
        return this.levitationAmplifier;
    }

    public Vec3 getLightningPos() {
        return this.lightningPos;
    }

    public WeakReference<LightningBolt> getBolt() {
        return this.bolt;
    }

    public static class Type
    extends AbstractSimpleAttack.Type<SmiteAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SmiteAttack>, SmiteAttack> buildCodec(RecordCodecBuilder.Instance<SmiteAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), (App)Codec.BOOL.fieldOf("aerial").forGetter(SmiteAttack::isAerial), (App)ExtraCodecs.f_144628_.fieldOf("levitation_duration").forGetter(SmiteAttack::getLevitationDuration), (App)ExtraCodecs.f_144628_.fieldOf("levitation_amplifier").forGetter(SmiteAttack::getLevitationAmplifier)).apply(instance, this.applyAttackExtras(SmiteAttack::new));
        }
    }
}

