/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.vampire;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSpecGrabAttack;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.common.attack.moves.vampire.BloodSuckHitsAttack;
import net.arna.jcraft.common.spec.VampireSpec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BloodSuckAttack
extends AbstractSpecGrabAttack<BloodSuckAttack, VampireSpec, VampireSpec.State> {
    private WeakReference<LivingEntity> target = null;

    public BloodSuckAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super VampireSpec> hitMove, int grabDuration, double grabOffset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMove, VampireSpec.State.BLOODSUCK_HIT, grabDuration, grabOffset);
    }

    public BloodSuckAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super VampireSpec> hitMove) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMove, VampireSpec.State.BLOODSUCK_HIT);
    }

    @Override
    @NotNull
    public MoveType<BloodSuckAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void performHook(VampireSpec attacker, Set<LivingEntity> targets, Set<AABB> boxes, DamageSource damageSource, Vec3 forwardPos, Vec3 rotationVector) {
        if (!targets.isEmpty()) {
            Player player;
            LivingEntity livingEntity = this.getHitMove();
            if (livingEntity instanceof BloodSuckHitsAttack) {
                BloodSuckHitsAttack bloodSuckHitsAttack = (BloodSuckHitsAttack)livingEntity;
                bloodSuckHitsAttack.setTarget(new WeakReference<LivingEntity>((LivingEntity)targets.stream().findFirst().get()));
            }
            if (attacker != null && (livingEntity = attacker.getUser()) instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
                player.m_36220_((ResourceLocation)JStatRegistry.BLOOD_SUCKED.get());
            }
        }
    }

    @Override
    @NonNull
    protected BloodSuckAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BloodSuckAttack copy() {
        return this.copyExtras(new BloodSuckAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getHitMove(), this.getGrabDuration(), this.getGrabOffset()));
    }

    public static class Type
    extends AbstractSpecGrabAttack.Type<BloodSuckAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<BloodSuckAttack>, BloodSuckAttack> buildCodec(RecordCodecBuilder.Instance<BloodSuckAttack> instance) {
            return this.grabDefault(instance, BloodSuckAttack::new);
        }
    }
}

