/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.vampire;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.spec.VampireSpec;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;

public class BloodSuckHitsAttack
extends AbstractMultiHitAttack<BloodSuckHitsAttack, VampireSpec> {
    private WeakReference<LivingEntity> target;

    public BloodSuckHitsAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public MoveType<BloodSuckHitsAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(VampireSpec attacker, LivingEntity user) {
        float bloodMult;
        Set<LivingEntity> targets = super.perform(attacker, user);
        user.m_5634_(1.0f);
        LivingEntity target = (LivingEntity)this.target.get();
        float f = bloodMult = target == null ? 0.0f : JUtils.getBloodMult(target);
        if (bloodMult <= 0.0f) {
            return targets;
        }
        attacker.getVampireComponent().setBlood(attacker.getVampireComponent().getBlood() + 2.0f * bloodMult);
        JUtils.serverPlaySound((SoundEvent)JSoundRegistry.VAMPIRE_SUCK.get(), (ServerLevel)user.m_9236_(), user.m_20182_(), 32.0);
        return targets;
    }

    @Override
    @NonNull
    protected BloodSuckHitsAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BloodSuckHitsAttack copy() {
        return this.copyExtras(new BloodSuckHitsAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public void setTarget(WeakReference<LivingEntity> target) {
        this.target = target;
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<BloodSuckHitsAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BloodSuckHitsAttack>, BloodSuckHitsAttack> buildCodec(RecordCodecBuilder.Instance<BloodSuckHitsAttack> instance) {
            return this.multiHitDefault(instance, BloodSuckHitsAttack::new);
        }
    }
}

