/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.vampire;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.common.spec.VampireSpec;
import net.arna.jcraft.common.tickable.Revivables;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public final class ReviveMove
extends AbstractMove<ReviveMove, VampireSpec> {
    public ReviveMove(int cooldown, int windup, int duration, float reviveDistance) {
        super(cooldown, windup, duration, reviveDistance);
    }

    @Override
    @NonNull
    public MoveType<ReviveMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(VampireSpec attacker, LivingEntity user) {
        MinecraftServer server = user.m_20194_();
        if (server == null) {
            return Set.of();
        }
        ServerLevel serverWorld = server.m_129880_(user.m_9236_().m_46472_());
        if (serverWorld == null) {
            return Set.of();
        }
        for (Revivables.ReviveData revivable : Revivables.getAround(user.m_20182_(), this.getMoveDistance())) {
            LivingEntity living;
            Entity entity;
            EntityType entityType = revivable.getType();
            if (entityType.m_204039_(EntityTypeTags.f_13121_) || entityType.equals(EntityType.f_20492_)) {
                entityType = EntityType.f_20530_;
            }
            if (entityType.equals(EntityType.f_20532_)) {
                entityType = EntityType.f_20501_;
            }
            if (!((entity = entityType.m_20615_((Level)serverWorld)) instanceof LivingEntity) || ReviveMove.isBoss(living = (LivingEntity)entity) || !living.m_21222_()) continue;
            entity.m_146884_(revivable.getPos());
            entity.f_19797_ = 1;
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                JComponentPlatformUtils.getMiscData(living).setSlavedTo(serverPlayer.m_20148_());
                serverPlayer.m_36220_((ResourceLocation)JStatRegistry.VAMPIRE_REVIVES.get());
            }
            serverWorld.m_7967_(entity);
            Revivables.removeRevivable(revivable);
        }
        return Set.of();
    }

    public static boolean isBoss(LivingEntity living) {
        return living.m_21233_() >= 80.0f;
    }

    @Override
    @NonNull
    protected ReviveMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public ReviveMove copy() {
        return this.copyExtras(new ReviveMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<ReviveMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ReviveMove>, ReviveMove> buildCodec(RecordCodecBuilder.Instance<ReviveMove> instance) {
            return this.baseDefault(instance, ReviveMove::new);
        }
    }
}

